/** @file sys_main.c 
*   @brief Application main file
*   @date 9.Sep.2014
*   @version 04.01.00
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* (c) Texas Instruments 2009-2014, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "svc.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#pragma CODE_STATE (testFromThumb2Mode, 16);
static void testFromThumb2Mode(void)
{
	register uint32_t u32Mode = 0x13ul; /* Supervisor */

	u32Mode = switchCpuMode(u32Mode);
	ASSERT(0x1Ful == u32Mode);

	switchToSystemMode();

	switchToUserMode();

	ASSERT(0x10ul       == switchCpuMode(u32Mode));

	*(uint32_t *)0x08000000 = 0xAA3355AAul;

	ASSERT(0xAA3355AAul == writePrivRegister32((uint32_t *)0x08000000, 0x12345678ul));
	ASSERT(*(uint32_t *)0x08000000 == 0x12345678ul);

	ASSERT(0x34ul       == writePrivRegister8 ( (uint8_t *)0x08000002, 0xAAu));
	ASSERT(*(uint32_t *)0x08000000 == 0x12AA5678ul);

	ASSERT(0ul          == testReentrantSVC((uint32_t *)0x08000004, 8ul)); /* Write to 0x08000004 and following 7 words */
	ASSERT(*(uint32_t *)0x08000004 == 0x08000004ul);
	ASSERT(*(uint32_t *)0x08000008 == 0x08000008ul);
	ASSERT(*(uint32_t *)0x0800001C == 0x0800001Cul);
	ASSERT(*(uint32_t *)0x08000020 == 0x08000020ul);
}

#pragma CODE_STATE (main, 32);
/* USER CODE END */

void main(void)
{
/* USER CODE BEGIN (3) */
	register uint32_t u32Mode = 0x13ul; /* Supervisor */

	u32Mode = switchCpuMode(u32Mode);
	ASSERT(0x1Ful == u32Mode);

	switchToSystemMode();

	switchToUserMode();

	ASSERT(0x10ul       == switchCpuMode(u32Mode));

	*(uint32_t *)0x08000000 = 0xAA3355AAul;

	ASSERT(0xAA3355AAul == writePrivRegister32((uint32_t *)0x08000000, 0x12345678ul));
	ASSERT(*(uint32_t *)0x08000000 == 0x12345678ul);

	ASSERT(0x34ul       == writePrivRegister8 ( (uint8_t *)0x08000002, 0xAAu));
	ASSERT(*(uint32_t *)0x08000000 == 0x12AA5678ul);

	ASSERT(0ul          == testReentrantSVC((uint32_t *)0x08000004, 8ul)); /* Write to 0x08000004 and following 7 words */
	ASSERT(*(uint32_t *)0x08000004 == 0x08000004ul);
	ASSERT(*(uint32_t *)0x08000008 == 0x08000008ul);
	ASSERT(*(uint32_t *)0x0800001C == 0x0800001Cul);
	ASSERT(*(uint32_t *)0x08000020 == 0x08000020ul);

	*(uint32_t *)0x08000000 = 0x00000000ul;
	*(uint32_t *)0x08000004 = 0x00000000ul;
	*(uint32_t *)0x08000008 = 0x00000000ul;
	*(uint32_t *)0x0800001C = 0x00000000ul;
	*(uint32_t *)0x08000020 = 0x00000000ul;

	testFromThumb2Mode();

	unimplementedSVC(); /* This "fault" should be handeled in the C level SVC handler --> ASSERTION, File: '../source/svc.c', Line: xx */

	while(1);
/* USER CODE END */
}

/* USER CODE BEGIN (4) */
/* USER CODE END */
